



export class SlotplanDayWidget {
	
	

	tpl = `
		<div class="slotplan-config-day" ez-for="days" ez-item="day">
		
			<div class="day-no day-{{day.dayno}}" day="{{day.dayno}}">
				<input type="checkbox" 
						id="day-no-{{day.dayno}}" 
						class="days-planned" 
						day="{{day.dayno}}" 
						name="day{{day.dayno}}-checked" 
						[onchange]="widget.day_Change"
						[checked]="{{day.active}}" />
				
				<label for="day-no-{{day.dayno}}" class="day-title">{{_uc('dayno.'+day.dayno)}}</label>
				
				<ez-select name="day{{day.dayno}}-pricetype" 
							label="Prijstype" 
							[value]="day.slotplanPricetypeId"
							[options]="pricetypes"></ez-select>
			</div>

		</div>
	`;
	
	
	container = null;
	
	slotplan = null;
	
	days = {};
	pricetypes = [];
	
	
	constructor( slotplan, pricetypes ) {
		this.slotplan = slotplan;
		this.pricetypes = pricetypes;
	}
	
	getDays() {
		for(let i=1; i <= 7; i++) {
			let ptid = $('.slotplan-config-day').find('select[name=day'+i+'-pricetype]').val();
				
			let active = $('.slotplan-config-day').find('input#day-no-'+i).prop('checked') ? 1 : 0;
			
			this.days[i].slotplanPricetypeId = ptid;
			this.days[i].active = active;
		}
		
		return this.days;
	}
	
	init( e ) {
		this.container = e;
		
		// init days
		this.days = {};
		for(let i=1; i <= 7; i++) {
			this.days[i] = {
				dayno: i
			};
		}
		
		// set values
		if ( this.slotplan && this.slotplan.slotitemDays ) {
			for(let i in this.slotplan.slotitemDays) {
				let sid = this.slotplan.slotitemDays[i];
				
				if (sid.dayno >= 1 && sid.dayno <= 7)
					this.days[ sid.dayno ] = sid;
			}
		}
	}
	
	day_Change( evt, inp ) {
		let dayno = inp.getAttribute('day');
		
		this.days[dayno].active = inp.checked ? true : false;
	}
	
	
	
	render() {
		let ht = new EzTemplate( this.container );
		ht.setObject('widget', this);
		ht.setVar('days', this.days);
		ht.setVar('pricetypes', this.pricetypes);
		ht.loadHtml( this.tpl );
		
		ht.render();
	}
	
	
	
	
}



